//=============================================================================
// RPGツクールMZ - ChangeExp.js
//-----------------------------------------------------------------------------
// このプラグインは以下の記事を参考に作成されました。
//
// https://qiita.com/kotonoha0109/items/7246db7fbee9029d4d4a
//=============================================================================

/*:ja
 * @target MZ
 * @plugindesc 獲得経験値の倍率を設定できるようになります。
 * @author emoriiin979
 *
 * @help ChangeExp.js
 *
 * 獲得経験値の倍率を設定できるようになります。
 * プラグインコマンドはありません。
 *
 * @param variableId
 * @text 変数ID
 * @desc 獲得経験値の倍率を格納する変数を選択してください。
 * @default 1
 * @type variable
 */

(() => {
    "use strict";

    const pluginName = "ChangeExp";
    const parameters = PluginManager.parameters(pluginName);

    //-------------------------------------------------------------------------
    // BattleManager
    //
    // 獲得経験値の倍率を変数と紐づけます。

    const _BattleManager_makeRewards = BattleManager.makeRewards;
    BattleManager.makeRewards = function() {
        _BattleManager_makeRewards.call(this);
        const expRate = $gameVariables.value(parameters["variableId"]) / 100;
        this._rewards.exp = Math.floor(this._rewards.exp * expRate);
    };
})();
